#!/usr/bin/perl -w
use Capture::Tiny 'capture';
use Devel::GDB;
use File::Find;
$successcnt=0;
@files = <dc17ctf-httpcookie-segv.pcap>;
while(1){
foreach $file (@files) {
	print $file . "\n";
    ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime(time);
    #$timestamp = sprintf "%4d-%02d-%02d-%02d-%02d-%02d",$year+1900,$mon+1,$mday,$hour,$min,$sec;
    #$fuzzedfile = $file . "-fuzz-" . $timestamp;
    #system("editcap -E 0.02 " . $file . " " . $fuzzedfile);
    $fuzzedfile = $file; 
	$fullcmd = "ulimit -c unlimited; src/suricata -c suricata117.yaml -r " . $fuzzedfile
		  . " -l ./ -s /home/coz/downloads/current-all-blah.rules";
	print "running $fullcmd \n";
	( $out, $err ) = capture {
		system $fullcmd;
		$exit = $? >> 8;
	};

	#print "out:$out\n";
	#print "err:$err\n";
	print "exit value $exit\n";
	if ( $exit ne 0 ) {
        
		$report = $fuzzedfile . "ERR.txt";
		open( REPORT, ">$report" )
		  || (print "Could not open report file! $report\n" );

		#print REPORT "$0\n";
		print REPORT "COMMAND:$fullcmd\n";
		print REPORT "STDERR:$err\n";
		print REPORT "EXITVAL:$exit\n";
		print REPORT "STDOUT:$out\n";

		&core_dump();
		if ($core_dump) {
			print REPORT $core_dump;
		print "core dump \n $core_dump";
		system("mv /home/coz/downloads/oisfnew/core " . $fuzzedfile . ".core");
		}
		close(REPORT);
        exit;
	}else{
        $successcnt++;
        print("we have run with success " . $successcnt . " times\n");
        #system("rm -f" . $fuzzedfile);
    }
}
}
sub core_dump {
	my $self = shift;
	$core_dump = "";

	if ( eval { require Devel::GDB } ) {
		find( \&dump_core_file, "/home/coz/downloads/oisfnew/" );
	}

	$core_dump || '  [CORE TRACE COMES HERE]';
}

sub dump_core_file {
	return unless /^core(\.\d+)?$/;

	my $core = $_;
	print "core dump found $core processesing \n";
	my $gdb = new Devel::GDB();
	$core_dump .= join '', $gdb->get("file /home/coz/downloads/oisfnew/src/suricata"),
	  $gdb->get('sharedlibrary'), $gdb->get("core $core"),

	  #$gdb->get('info threads'),
	  #$gdb->get('thread apply all bt full');
	  $gdb->get('bt full');
	print "core dump \n $core_dump";
	
}
