import suricatasc
import sys
import json
import glob
import os
import time

mysocket = "/usr/local/var/run/suricata/test.sock"
pcap_dir = "/src/suricata-current/python"
pcap_list = glob.glob(os.path.join(pcap_dir, "*.pcap"))


class SocketController:
    def __init__(self, socket_path):
        try:
            self.sc = suricatasc.SuricataSC(socket_path)
            self.sc.connect()
        except Exception as e:
            print("ERROR creating/connecting Unix socket: %s" % e)
            sys.exit(1)

    def send_command(self, command):
        try:
            cmd, arguments = self.sc.parse_command(command)
            cmdret = self.sc.send_command(cmd, arguments)
        except Exception as e:
            print("ERROR parsing/sending command: %s" % e)
            sys.exit(1)

        if cmdret["return"] == "NOK":
            print("ERROR: %s" % json.dumps(cmdret["message"]))
            sys.exit(1)

        return json.dumps(cmdret["message"])

    def close(self):
        self.sc.close()
        print("Closed.")


mysc = SocketController("/usr/local/var/run/suricata/test.sock")

print("Suri version: %s" % mysc.send_command("version"))
print("pcap_list: %s" % pcap_list)

MYMAX = 5
print(f"Doing {MYMAX} sub-rounds ...")

for i in range(1,MYMAX):
    if not os.path.exists(f"/tmp/sraw{i}"):
        os.mkdir("/tmp/sraw%d" % i)

count = 0
while True:
    print(f"Round {count}")
    mysc = SocketController(mysocket)
    for i in range(1,5):
        print(f"\tsub-round {i}...")
        for pcap in pcap_list:
            print(f"\t  sending pcap '{pcap}'")
            resp = mysc.send_command(f"pcap-file {pcap} /tmp/sraw{i}")
            #print("Response: %s" % resp)

        files_remaining = 1
        while files_remaining > 0 or current_pcap != "\"None\"":
            files_remaining = int(mysc.send_command("pcap-file-number"))
            current_pcap = mysc.send_command("pcap-current")
            #print(f"files_remaining: {files_remaining}, current_pcap: {current_pcap}")
        while not os.path.isfile(os.path.join(f"/tmp/sraw{i}", "fast.log")):
            print("wait on file")
            time.sleep(.1)

        mysc.send_command("reopen-log-files")

    mysc.close()
    time.sleep(1)
    count += 1
